#include <stdio.h>
#include <stdlib.h>

#include "db.h"

char *names[] = { "last name", "first name", "rank", "serial number", "addr" };
db_datum_type_t types[] = { DBD_STR, DBD_STR, DBD_STR, DBD_INT, DBD_MAC };

int
main(int argc, char **argv)
{
  db_database_ptr_t dp;
  db_table_ptr_t tp;
  db_datum_t qq;
  db_datum_t **qres;
  int nres;
  int i;

  dp = db_open_database("/tmp", "testdb", 1);
  if (dp == NULL) {
    fprintf(stderr, "database open failed\n");
    exit(1);
  }

  tp = db_open_table(dp, "table1");
  if (tp == NULL) {
    fprintf(stderr, "table open failed\n");
    exit(1);
  }

  qq.type = DBD_STR;
  qq.dbd_str = "general";

  /* try out a query */
  db_simple_query(tp, 2, &qq, &qres, &nres);
  printf("%d generals:\n", nres);
  for (i=0; i<nres; ++i) {
    printf("\t%s %s\n", qres[i][1].dbd_str, qres[i][0].dbd_str);
  }
  db_free_query_res(tp, qres, nres);

  {
    db_datum_t *qr;
    int i;
    qr = (db_datum_t *) calloc(sizeof(db_datum_t), 5);
    for (i=0; i<5; ++i) {
      qr[i].type = DBD_MATCHALL;
    }

    qr[2].type = DBD_STR;
    qr[2].dbd_str = "general";

    printf("=== run row_query ===\n");
    db_row_query(tp, qr, &qres, &nres);
    for (i=0; i<nres; ++i) {
      printf("\t%s %s\n", qres[i][1].dbd_str, qres[i][0].dbd_str);
    }
    db_free_query_res(tp, qres, nres);

    qr[0].type = DBD_STR;
    qr[0].dbd_str = "gallatin";

    printf("=== run row_delete ===\n");

    db_row_delete(tp, qr);

    qr[0].type = DBD_MATCHALL;
    printf("=== run row_query again ===\n");
    db_row_query(tp, qr, &qres, &nres);
    for (i=0; i<nres; ++i) {
      printf("\t%s %s\n", qres[i][1].dbd_str, qres[i][0].dbd_str);
    }
    db_free_query_res(tp, qres, nres);
  }

  db_flush_table(tp);
  db_close_table(tp);
  db_close_database(dp);

  return 0;
}
